<?php

namespace App\Models;

use App\Enums\{Priorities,Status,Organize};
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Tickets extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id', 
        'subject', 
        'message', 
        'status', 
        'priority', 
        'cc', 
        'assigned',
        'department_id',
        'public_hash', 
        'public_name',
        'public_email', 
        'ip_address',
        'rating',
        'organize',
        'date_closed',
        'updated_by_client_at',
        'first_employee_reply',
    ];

    protected $casts = [
        'status' => Status::class,
        'priority' => Priorities::class,
        'organize' => Organize::class,
    ];

    /**
     * Get all attachments for this ticket.
     */
    public function attachments(): HasMany
    {
        return $this->hasMany(Attachment::class, 'ticket_id');
    }

    /**
     * Get all responses for this ticket.
     */
    public function responses(): HasMany
    {
        return $this->hasMany(Responses::class, 'ticket_number', 'id');
    }

    /**
     * Get the department this ticket belongs to.
     */
    public function department(): BelongsTo
    {
        return $this->belongsTo(Departments::class, 'department_id');
    }

    /**
     * Get the user who created this ticket.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Get the assigned employee for this ticket.
     */
    public function assignedEmployee(): BelongsTo
    {
        return $this->belongsTo(User::class, 'assigned');
    }
}
