<?php

namespace App\Models;

use App\Enums\{Organize};
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Responses extends Model
{
    use HasFactory;
    protected $fillable = [
        'user_id', 
        'ticket_number', 
        'content', 
        'organize', 
        'is_note', 
        'employee_response', 
        'ip_address',
    ];

    protected $casts = [
        'organize' => Organize::class,
    ];

    /**
     * Get all attachments for this response.
     */
    public function attachments(): HasMany
    {
        return $this->hasMany(Attachment::class, 'response_id');
    }

    /**
     * Get the ticket this response belongs to.
     */
    public function ticket(): BelongsTo
    {
        return $this->belongsTo(Tickets::class, 'ticket_number', 'id');
    }

    /**
     * Get the user who created this response.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
