<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Extension extends Model
{
    protected $fillable = [
        'extension_id',
        'name',
        'version',
        'installed',
        'enabled',
        'settings',
    ];

    protected $casts = [
        'installed' => 'boolean',
        'enabled' => 'boolean',
        'settings' => 'array',
    ];

    /**
     * Scope to get only enabled extensions
     */
    public function scopeEnabled($query)
    {
        return $query->where('enabled', true);
    }

    /**
     * Scope to get only disabled extensions
     */
    public function scopeDisabled($query)
    {
        return $query->where('enabled', false);
    }
}
