<?php

    namespace App\Mail\Tickets;

    use App\Models\Departments;
    use Illuminate\Bus\Queueable;
    use Illuminate\Contracts\Queue\ShouldQueue;
    use Illuminate\Mail\Mailable;
    use Illuminate\Mail\Mailables\Content;
    use Illuminate\Mail\Mailables\Address;
    use Illuminate\Mail\Mailables\Envelope;
    use Illuminate\Queue\SerializesModels;

    class Response extends Mailable
    {
        use Queueable, SerializesModels;

        /**
         * Create a new message instance.
         */
        public function __construct(
            protected $response,
            protected $ticket,
            protected $public_hash,
            protected $customer_name
        ) {
            $this->response = $response;
            $this->ticket = $ticket;
            $this->public_hash = $public_hash;
            $this->customer_name = $customer_name;
        }

        /**
         * Get the message envelope.
         */
        public function envelope(): Envelope
        {
            $subject = $this->ticket['subject'];
            $department = Departments::select('department_name', 'department_email')->where('id', '=', $this->ticket['department_id'])->first();
            $email_company = config('app.name') . ': ' .$department->department_name;
            return new Envelope(
                from: new Address($department->department_email, $email_company),
                subject: 'Re: ' .$subject.'.',
            );
        }

        /**
         * Get the message content definition.
         */
        public function content(): Content
        {

            $ticket_public_url = config('app.url').'/'.'tickets/public/'.$this->response['ticket_number'].'/'.$this->public_hash;
            $author_name = $this->ticket['public_name'] ?: $this->customer_name;
            $ip_address = app('request')->ip();

            return new Content(
                markdown: 'emails.tickets.response',
                with: [
                    'ticketId' => $this->response['ticket_number'],
                    'ticketPublicUrl' => $ticket_public_url,
                    'authorName' => $author_name,
                    'responseContent' => $this->response['content'],
                    'ticketStatus' => $this->ticket['status'],
                    'ticketPriority' => $this->ticket['priority'],
                    'authorIPaddress' => $ip_address,
                    'subject' => $this->ticket['subject'],
                ],
            );
        }

        /**
         * Get the attachments for the message.
         *
         * @return array<int, \Illuminate\Mail\Mailables\Attachment>
         */
        public function attachments(): array
        {
            return [];
        }
    }
