<?php

namespace App\Mail\Tickets;

use App\Models\{Departments};
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Address;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Auth;

class Created extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     */
    public function __construct(
        protected $ticket
    ) {
        $this->ticket = $ticket;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        $department = Departments::select('department_name', 'department_email')->where('id', '=', $this->ticket['department_id'])->first();
        $email_company = config('app.name').': '.$department->department_name;
            
        return new Envelope(
            from: new Address($department->department_email, $email_company),
            subject: 'Ticket #'.$this->ticket['id'].' has been created.',
        );
    }


    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
        $ticket_public_url = config('app.url').'/'.'tickets/public/'.$this->ticket['id'].'/'.$this->ticket['public_hash'];
        
        if (Auth::check()) {
            $author_name = Auth::user()->name;
        } else {
            $author_name = $this->ticket['public_name'];
        }
        
        $ip_address = app('request')->ip();

        return new Content(
            markdown: 'emails.tickets.new',
            with: [
                'ticketId' => $this->ticket['id'],
                'ticketPublicUrl' => $ticket_public_url,
                'authorName' => $author_name,
                'ticketContent' => $this->ticket['message'],
                'ticketStatus' => $this->ticket['status'],
                'ticketPriority' => $this->ticket['priority'],
                'authorIPaddress' => $ip_address,
            ],
        );
    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }
}
