<?php

namespace App\Livewire\Tickets;

use App\Models\Tickets;
use App\Http\Controllers\{TicketsController};

use Livewire\Component;

class Close extends Component
{

    public $ticket_id;

    public function mount($ticket_id)
    {
        $this->ticket_id = $ticket_id;
    }

    public function close()
    {
        TicketsController::destroy([
            'ticket_number' => $this->ticket_id,
        ]);

        // Dispatch event to update sidebar counts
        $this->dispatch('ticket-updated')->to('sidebar-navigation');
        $this->dispatch('ticket-updated')->to('sidebar-assigned-tickets');

        // Refresh the page to show updated ticket status
        $this->redirect('/tickets/show/' . $this->ticket_id);
    }
    
    public function render()
    {
        $ticket = Tickets::where('id', '=', $this->ticket_id)->first();

        return view('livewire.tickets.close',[
            'ticket' => $ticket,
        ]);
    }
}
