<?php

namespace App\Livewire;

use App\Models\Tickets;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;
use Livewire\Attributes\On;

class SidebarAssignedTickets extends Component
{
    public $assignedTicketsCount = 0;

    public function mount()
    {
        $this->updateCount();
    }

    #[On('ticket-updated')]
    public function updateCount()
    {
        if (Auth::check()) {
            // Count all non-closed tickets assigned to the current user
            $this->assignedTicketsCount = Tickets::where('assigned', auth()->id())
                ->where('status', '!=', 'closed')
                ->count();
        }
    }

    public function getBadgeColorProperty()
    {
        if ($this->assignedTicketsCount > 9) {
            return 'red';
        }
        return 'zinc';
    }

    public function render()
    {
        return view('livewire.sidebar-assigned-tickets');
    }
}
