<?php

namespace App\Livewire\Partials\Tickets;

use App\Models\{User,Tickets};
#use App\Http\Controllers\{TicketsController};

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\{DB, Auth};
use Illuminate\Http\RedirectResponse;

use Livewire\Component;

class StatisticsAssigned extends Component
{
    public function render()
    {
        $count_open = Tickets::where('status', '!=', 'closed')->where('assigned', '=', Auth::user()->id)->get();
        $high_priority = Tickets::where('assigned', '=', Auth::user()->id)->where('status', '!=', 'closed')->whereIn('priority', ['high', 'emergency'])->get();
        $all_count = Tickets::all()->where('assigned', '=', Auth::user()->id);

        return view('livewire.partials.tickets.statistics-assigned',[
            'open_count' => count($count_open),
            'high_priority' => count($high_priority),
            'all_count' => count($all_count),
        ]);
    }
}
