<?php

    namespace App\Livewire\Partials\Tickets;

    use App\Http\Controllers\{TicketsController};
    use App\Models\{User,Departments,Tickets};

    use Illuminate\Support\Facades\Auth;
    use Illuminate\Support\{Str,Carbon};

    use Livewire\Attributes\{Rule, Validate};
    use Livewire\Component;

    use Filament\Notifications\Notification;

class ChangeDepartment extends Component
{
    #[Validate('required')]
    public $department_id = '';

    public $ticket_id;

    public function mount($ticket_id)
    {
        $this->ticket_id = $ticket_id;
    }

    public function change()
    {
        Tickets::where('id', '=', $this->ticket_id)->update([
            'department_id' => $this->department_id,
        ]);
            
        Notification::make()
            ->title("Ticket updated successfully")
            ->success()
            ->body("The ticket's department has been updated.")
            ->color('success') 
            ->send();

        $this->redirect('/tickets/show/'.$this->ticket_id);
    }

    public function render()
    {
        $departments = Departments::select('id', 'department_name')->get();
        return view('livewire.partials.tickets.change-department',[
            'departments' => $departments,
        ]);
    }
}