<?php

    namespace App\Livewire\Partials\Tickets;

    use App\Http\Controllers\{TicketsController};
    use App\Models\{User,Departments,Tickets};

    use Illuminate\Support\Facades\Auth;

    use Livewire\Attributes\{Rule, Validate};
    use Livewire\Component;

    use Filament\Notifications\Notification;

class ChangeCustomer extends Component
{
    #[Rule('numeric', message: "Please select a customer.")]
    #[Validate('required')]
    public $customer_id = '';

    public $ticket_id;

    public function mount($ticket_id)
    {
        $this->ticket_id = $ticket_id;
    }

    public function change()
    {
        $this->validate();

        Tickets::where('id', '=', $this->ticket_id)->update([
            'user_id' => $this->customer_id,
        ]);
            
        Notification::make()
            ->title("Ticket updated successfully")
            ->success()
            ->body("The ticket's customer has been updated.")
            ->color('success') 
            ->send();

        $this->redirect('/tickets/show/'.$this->ticket_id);
    }

    public function render()
    {
        $users = User::select('id', 'name', 'email')->get();
        return view('livewire.partials.tickets.change-customer',[
            'users' => $users,
        ]);
    }
}
