<?php

    namespace App\Livewire\Partials\Tickets;

    use App\Mail\Tickets\{Assigned};
    use App\Http\Controllers\{TicketsController};
    use App\Models\{User,Departments,Tickets, Responses};

    use Illuminate\Support\Facades\{Auth, Mail};
    use Illuminate\Support\{Str,Carbon};

    use Livewire\Attributes\{Rule, Validate};
    use Livewire\Component;

    use Filament\Notifications\Notification;

class AssignTicket extends Component
{
    #[Rule('numeric', message: "Please select an employee.")]
    #[Validate('required')]
    public $employee_id = '';

    public $ticket_id;

    public function mount($ticket_id)
    {
        $this->ticket_id = $ticket_id;
    }

    public function change()
    {
        $this->validate();

        Tickets::where('id', '=', $this->ticket_id)->update([
            'assigned' => $this->employee_id,
        ]);

        if($this->employee_id != '0')
        {
            $employee = User::where('id', '=', $this->employee_id)->first();
            $content = "This ticket has been assigned to " . $employee->name . ". Our employee will read the ticket and get back to you as soon as possible.";

            Responses::create([
                'user_id' => '0',
                'content' => $content,
                'ticket_number' => $this->ticket_id,
                'is_note' => '2',
                'employee_response' => '1',
                'ip_address' => '',
                'created_at' => Carbon::now(),
                'updated_at' => null,
            ]);
        }
        
        $notification_message = "The ticket has been assigned to " . User::where('id', '=', $this->employee_id)->pluck('name')->first() . ".";
        Notification::make()
            ->title("Ticket updated successfully")
            ->success()
            ->body($notification_message)
            ->color('success')
            ->send();

        // Dispatch event to update sidebar counts
        $this->dispatch('ticket-updated')->to('sidebar-navigation');
        $this->dispatch('ticket-updated')->to('sidebar-assigned-tickets');

        if(config("mail.enabled") == 'true')
        {
            // Grab the ticket information
            $grab_ticket = Tickets::where('id', '=', $this->ticket_id)->get()->toArray();

            // Grab the Customers email from the Ticket
            $customer_email = User::select('email')->where('id', '=', $grab_ticket[0]['user_id'])->first();

            // Defines the email address for the user, logged in or the public email address
            $user_email = $customer_email ?? $grab_ticket[0]['public_email'];
            
            // Send Email
            Mail::to($user_email)->bcc($employee->email)->send(new Assigned($grab_ticket[0]));
        }

        $this->redirect('/tickets/show/'.$this->ticket_id);
    }

    public function render()
    {
        $employees = User::role(['superadmin', 'admin', 'employee'])->get();
        return view('livewire.partials.tickets.assign-ticket',[
            'employees' => $employees,
        ]);
    }
}
