<?php

namespace App\Livewire\Partials\Customers;

use Illuminate\Support\Facades\{DB};

use Livewire\Component;

class Status extends Component
{
    public $user_id;

    public function mount($user_id)
    {
        $this->user_id = $user_id;
    }

    public function render()
    {
        $online_status = DB::table('sessions')
                            ->distinct()
                            ->select(['users.id', 'users.name'])
                            ->whereNotNull('user_id')
                            ->leftJoin('users', 'sessions.user_id', '=', 'users.id')
                            ->where('users.id', '=', $this->user_id)
                            ->first();
        return view('livewire.partials.customers.status',[
            'online_status' => $online_status,
        ]);
    }
}
