<?php

    namespace App\Livewire\Partials\Customers;

    use App\Models\{User};

    use Illuminate\Support\Facades\{Hash,Auth};
    use Illuminate\Support\{Str,Carbon};

    use Illuminate\Validation\Rules\Password;
    use Illuminate\Validation\ValidationException;

    use Livewire\Attributes\{Rule,Validate};
    use Filament\Notifications\Notification;

    use Livewire\Component;

class Passwords extends Component
{
    public $user;

    public int $user_id;

    public string $password = '';

    public string $password_confirmation = '';

    public function mount($user_id, $user)
    {
        $this->user_id = $user_id;
        $this->user = $user;
    }

    public function generatePassword()
    {
        // Define character sets
        $uppercase = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $lowercase = 'abcdefghijklmnopqrstuvwxyz';
        $numbers = '0123456789';
        $symbols = '!@#$%^&*()_+-=[]{}|;:,.<>?';

        // Ensure at least one character from each required set
        $password = '';
        $password .= $uppercase[random_int(0, strlen($uppercase) - 1)];
        $password .= $lowercase[random_int(0, strlen($lowercase) - 1)];
        $password .= $numbers[random_int(0, strlen($numbers) - 1)];
        $password .= $symbols[random_int(0, strlen($symbols) - 1)];

        // Fill the rest to reach 20 characters (exceeds minimum of 15)
        $allCharacters = $uppercase . $lowercase . $numbers . $symbols;
        for ($i = 0; $i < 16; $i++) {
            $password .= $allCharacters[random_int(0, strlen($allCharacters) - 1)];
        }

        // Shuffle the password to randomize character positions
        $password = str_shuffle($password);

        // Set both password fields
        $this->password = $password;
        $this->password_confirmation = $password;

        Notification::make()
            ->title('Password Generated')
            ->success()
            ->body('A secure password has been generated and filled in the form.')
            ->color('success')
            ->send();
    }

    public function change()
    {
        try {
            $validated = $this->validate([
                'password' => ['required', 'string', Password::min(15)->uncompromised()->letters()->numbers()->symbols(), 'confirmed'],
            ]);
        } catch (ValidationException $e) {

            $this->reset('password', 'password_confirmation');
            throw $e;
        }

        User::where('id', '=', $this->user_id)->update([
            'password' => Hash::make($validated['password']),
            'force_password_reset' => true,
        ]);

        $this->reset('password', 'password_confirmation');

        $this->dispatch('password-updated');

        $this->redirect('/clients/view/'.$this->user_id);

        Notification::make()
            ->title('Customer has been updated successfully')
            ->success()
            ->body('The customer has been updated, and their new password has been set.')
            ->color('success')
            ->send();
    }

    public function render()
    {
        return view('livewire.partials.customers.passwords');
    }
}
