<?php

namespace App\Livewire\Partials\Customers;

    use App\Models\{User,Tickets};

    use Illuminate\Support\Facades\Hash;
    use Illuminate\Support\Facades\Auth;
    use Illuminate\Support\{Str,Carbon};

    use Livewire\Attributes\{Rule,Validate};
    use Livewire\Component;

    use Filament\Notifications\Notification;

class Details extends Component
{
    public $user;

    public $user_id;

    #[Rule('required', message: "Please enter the Customer's name.")]
    public $name = '';

    public $company = '';

    #[Rule('required|email', message: "Please enter a valid email address for this customer.")]
    public $email = '';

    public $phone_number = '';

    public function rules()
    {
        return [
            'phone_number' => 'phone:' . config('validation.phone_countries'),
        ];
    }

    protected $messages = [
        'phone_number.phone' => 'Please enter a valid phone number for this customer.',
    ];

    public function mount($user_id, $user)
    {
        $this->user_id = $user_id;
        $this->user = $user;

        $this->name = $this->user->name;
        $this->company = $this->user->company;
        $this->email = $this->user->email;
        $this->phone_number = $this->user->phone_number;
    }

    public function change()
    {
        $this->validate();

        User::where('id', '=', $this->user_id)->update([
            'name' => $this->name,
            'company' => $this->company,
            'email' => $this->email,
            'phone_number' => $this->phone_number,
        ]);

        Notification::make()
            ->title('Customer has been updated successfully')
            ->success()
            ->body('The customer has been updated.')
            ->color('success') 
            ->send();
        $this->redirect('/clients/view/'.$this->user_id);
    }

    public function render()
    {
        return view('livewire.partials.customers.details',[
            'name' => $this->user->name,
            'company' => $this->user->company,
            'email' => $this->user->email,
            'phone_number' => $this->phone_number,
        ]);
    }
}