<?php

namespace App\Livewire\Partials\Customers;

    use App\Models\{User,Tickets};
    use App\Enums\Organize;

    use Illuminate\Support\Facades\Hash;
    use Illuminate\Support\Facades\Auth;
    use Illuminate\Support\{Str,Carbon};

    use Livewire\Attributes\{Rule,Validate};
    use Livewire\Component;

    use Filament\Notifications\Notification;

class Billing extends Component
{
    public $user;

    public $user_id;

    public $billing_system = '';

    public $billing_id = '';

    public function mount($user_id, $user)
    {
        $this->user_id = $user_id;
        $this->user = $user;

        $this->billing_system = $this->user->billing_system;
        $this->billing_id = $this->user->billing_id;
    }

    public function change()
    {
        
        User::where('id', '=', $this->user_id)->update([
            'billing_system' => $this->billing_system,
            'billing_id' => $this->billing_id,
        ]);

        Notification::make()
            ->title('Customer has been updated successfully')
            ->success()
            ->body('The customer has been updated.')
            ->color('success') 
            ->send();

        $this->redirect('/clients/view/'.$this->user_id);
    }

    public function render()
    {
        return view('livewire.partials.customers.billing',[
            'billing_system' => $this->user->billing_system,
            'billing_id' => $this->user->billing_id,
            'billingSystemOptions' => Organize::billingSystemsOnly(),
        ]);
    }
}