<?php

namespace App\Livewire\Partials\Customers;

    use App\Models\{User,Tickets};

    use Illuminate\Support\Facades\Auth;
    use Illuminate\Support\{Str,Carbon};

    use Livewire\Attributes\{Rule,Validate};
    use Livewire\Component;

    use Filament\Notifications\Notification;

class Assign extends Component
{
    public $user = [];
    
    #[Rule('numeric', message: "Please select an employee.")]
    #[Validate('required')]
    public $employee_id = '';

    public $all_tickets = '';

    public $user_id;

    public function mount($user_id)
    {
        $this->user_id = $user_id;
    }

    public function change()
    {
        $this->validate();

        User::where('id', '=', $this->user_id)->update([
            'account_manager' => $this->employee_id,
        ]);

        if($this->all_tickets == '0')
        {
            $tickets = Tickets::where('user_id', '=', $this->user_id)->get();
            foreach($tickets as $ticket)
            {  
                Tickets::where('user_id', '=', $this->user_id)->update([
                    'assigned' => '0',
                ]);
            }
        } else {
            $tickets = Tickets::where('user_id', '=', $this->user_id)->get();
            foreach($tickets as $ticket)
            {  
                Tickets::where('user_id', '=', $this->user_id)->update([
                    'assigned' => $this->employee_id,
                ]);
            }
        }
        
        $notification_message = "The customer has been assigned to " . User::where('id', '=', $this->employee_id)->select('name')->first() . ".";
        Notification::make()
            ->title("Account Manager assigned successfully")
            ->success()
            ->body($notification_message)
            ->color('success') 
            ->send();

        $this->redirect('/clients/view/'.$this->user_id);
    }
    public function render()
    {
        $employees = User::role(['employee', 'admin', 'superadmin'])->get();

        return view('livewire.partials.customers.assign',[
            'employees' => $employees,
        ]);
    }
}
