<?php

namespace App\Livewire\Partials\Announcements\Categories;

use App\Models\{Categories};

use Illuminate\Http\Request;
use Illuminate\Support\{Str,Carbon};
use Illuminate\Support\Facades\Auth;

use Livewire\Attributes\Rule;

use Filament\Notifications\Notification;

use Livewire\Component;

class DisplayAll extends Component
{
    public function delete($category_id)
    {
        if (Auth::user()->hasAnyRole('admin')) {
            
            Categories::where('id', '=', $category_id)->delete();
                
            Notification::make()
                ->title('Deleted successfully')
                ->success()
                ->body('The Announcement category has been deleted.')
                ->color('success')
                ->send();
        }
    }

    public function render()
    {
        $categories = Categories::all()->where('type', '=', 'announcements');
        return view('livewire.partials.announcements.categories.display-all',[
            'categories' => $categories,
        ]);
    }
    
}
