<?php

    namespace App\Livewire\Departments;

    use App\Models\{Departments};
    use Illuminate\Support\Facades\Auth;
    use Livewire\Component;
    use Filament\Notifications\Notification;

    class View extends Component
    {

        public function soft_delete($department_id)
        {
            Departments::where('id', '=', $department_id)
                ->update([
                    'soft_deleted' => '1',
                ]);
                Notification::make()
                    ->title('Deleted successfully')
                    ->success()
                    ->body('The department has been deleted.')
                    ->color('info')
                    ->send();
        }

        public function delete($department_id)
        {
            if (Auth::user()->is_agent == '1' and Auth::user()->id == '1') {
                Departments::where('id', '=', $department_id)->delete();
                
                Notification::make()
                    ->title('Deleted successfully')
                    ->success()
                    ->body('The department has been deleted.')
                    ->color('success')
                    ->send();
            }
        }

        public function restore($department_id)
        {
            Departments::where('id', '=', $department_id)
                ->update([
                    'soft_deleted' => '0',
                ]);

            Notification::make()
                ->title('Restored successfully')
                ->success()
                ->body('The department has been restored.')
                ->color('success')
                ->send();
        }

        public function render()
        {
            if (Auth::check()) {
                if(Auth::user()->hasAnyRole('superadmin', 'admin', 'employee'))
                {
                    $departments = Departments::get();
                    $department_count = Departments::count();
                }else{
                    $departments = Departments::where('is_public', '!=', '0')->get();
                    $department_count = Departments::where('is_public', '!=', '0')->count();
                }
            } else {
                $departments = Departments::where('is_public', '=', '1')->get();
                $department_count = Departments::where('is_public', '=', '1')->count();
            }
            return view('livewire.departments.view', [
                'departments' => $departments,
                'department_count' => $department_count,
            ]);
        }
    }
