<?php

    namespace App\Livewire\Departments;

    use App\Models\Tickets;
    use Carbon\CarbonInterval;
    use Illuminate\Support\Facades\DB;
    use Livewire\Component;

class Eta extends Component
{
    public $department_id;

    public function mount($department_id)
    {
        $this->department_id = $department_id;
    }

    public function render()
    {
        $estimated_time = Tickets::select(DB::raw('AVG(TIMESTAMPDIFF(MINUTE, created_at, first_employee_reply)) as average_time'))
            ->where('department_id', '=', $this->department_id)
            ->first();

        $eta = CarbonInterval::minutes((int) $estimated_time->average_time)->cascade();

        return view('livewire.departments.eta', [
            'estimated_time' => $eta,
        ]);
    }
}
