<?php

namespace App\Livewire\Departments;

use App\Models\{Departments, MailAccount};
use App\Http\Controllers\{DepartmentsController};
use Illuminate\Http\Request;

use Illuminate\Support\{Str,Carbon};
use Illuminate\Support\Facades\Auth;

use Livewire\Attributes\Rule;
use Filament\Notifications\Notification;
use Livewire\Component;

class Edit extends Component
{
    public $department_id;
    #[Rule('required', message: "Please enter a name for the department.")]
    public $department_name;
    public $slug = '';

    public $department_description;

    #[Rule('required|email', message: "Please enter a valid email address for this department.")]
    public $department_email;

    public $allows_high_priority;
    public $cc_enabled;
    public $is_public;
    public $is_disabled;
    public $mail_account_id;

    public function mount(Request $request)
    {
        $department = Departments::where('id', '=', $request->route('id'))->first();

        $this->department_name = $department->department_name;
        $this->slug = $department->slug;
        $this->department_description = $department->department_description;
        $this->department_email = $department->department_email;
        $this->department_id = $department->id;
        $this->allows_high_priority = $department->allows_high_priority;
        $this->cc_enabled = $department->cc_enabled;
        $this->is_public = $department->is_public;
        $this->is_disabled = $department->is_disabled;
        $this->mail_account_id = $department->mail_account_id;

    }

    public function save(Request $request)
    {
        if ($this->slug == '') {
            $this->slug = Str::of($this->department_name)->slug('-');
        }
        $this->slug = Str::of($this->slug)->slug('-');
        
        DepartmentsController::update([
            'department_name' => $this->department_name,
            'slug' => str_replace(' ', '-', $this->slug),
            'department_description' => $this->department_description,
            'department_email' => $this->department_email,
            'allows_high_priority' => $this->allows_high_priority,
            'cc_enabled' => $this->cc_enabled,
            'department_id' => $this->department_id,
            'is_public' => $this->is_public,
            'is_disabled' => $this->is_disabled,
            'mail_account_id' => $this->mail_account_id ?: null,
        ]);

        Notification::make()
            ->title('Update successfully')
            ->success()
            ->body('The department has been updated.')
            ->color('success') 
            ->send();

        $this->redirect('/departments');
    }

    public function render()
    {
        $mailAccounts = MailAccount::active()->orderBy('is_default', 'desc')->orderBy('name')->get();
        return view('livewire.departments.edit', [
            'mailAccounts' => $mailAccounts,
        ]);
    }
}
