<?php

namespace App\Livewire\Announcements;

use App\Models\{Announcements,Categories};

use Illuminate\Http\Request;
use Illuminate\Support\{Str,Carbon};
use Illuminate\Support\Facades\Auth;

use Livewire\Attributes\{Rule, Validate};

use Filament\Notifications\Notification;

use Livewire\Component;

class Create extends Component
{
    #[Rule('required', message: "Please enter a title for the announcement.")]
    public $title = '';
    
    public $slug = '';
    public $image = '';

    #[Rule('required', message: "Please enter the content for the announcement.")]
    public $content = '';

    public $draft = '';
    public $private = '';

    #[Rule('numeric', message: "Please select a correct category.")]
    #[Validate('required')]
    public $parent_category;

    public function create()
    {
        $this->validate();
        if($this->slug)
        {
            $slug = Str::of($this->slug)->slug('-');
        } else {
            $slug = Str::of($this->title)->slug('-');
        }
        Announcements::create([
            'parent_category' => $this->parent_category,
            'title' => $this->title,
            'slug' => $slug,
            'image' => $this->image,
            'content' => $this->content,
            'tags'  => '',
            'draft' => $this->draft,
            'private' => $this->private,
            'author_id' => Auth::user()->id,
        ]);
        $this->reset();
        $this->redirect('/announcements');
    }

    public function render()
    {

        $categories = Categories::all()->where('type', '=', 'announcements');
        return view('livewire.announcements.create',[
            'categories' => $categories,
        ]);
    }
}
