<?php

namespace App\Livewire\Announcements\Categories;

use App\Models\{Announcements};

use Illuminate\Support\{Str,Carbon};
use Illuminate\Support\Facades\Auth;

use Livewire\Component;

class View extends Component
{
    public $category;

    public function mount($category)
    {
        $this->category = $category;
    }
    public function render()
    {
        if(!Auth::guest() && Auth::user()->hasAnyRole('superadmin', 'admin', 'employee'))
        {
            $announcements = Announcements::leftJoin('users', 'announcements.author_id', '=', 'users.id')
            ->leftJoin('categories', 'announcements.parent_category', '=', 'categories.id')
            ->select('announcements.*', 'categories.*', 'users.*')
            ->selectRaw('users.company as company_name, users.name as customer_name, announcements.id as announcement_id, categories.id as category_id, announcements.created_at as announcement_created')
            ->orderBy('announcement_id', 'DESC')
            ->where('parent_category', '=', $this->category->id)
            ->get();
        } else {
            $announcements = Announcements::leftJoin('users', 'announcements.author_id', '=', 'users.id')
            ->leftJoin('categories', 'announcements.parent_category', '=', 'categories.id')
            ->select('announcements.*', 'categories.*', 'users.*')
            ->selectRaw('users.company as company_name, users.name as customer_name, announcements.id as announcement_id, categories.id as category_id, announcements.created_at as announcement_created')
            ->orderBy('announcement_id', 'DESC')
            ->where('parent_category', '=', $this->category->id)
            ->where('announcements.draft', '!=', '1')->get();
        }
        return view('livewire.announcements.categories.view',[
            'announcements' => $announcements,
        ]);
    }
}
