<?php
namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class KeepAliveSession
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
	  	// This is a heartbeat request, we don't need anything in response
        if ($request->uri()->path() === '__heartbeat') {
            return response([]);
        }

	  	// Finish the rest of the request and get back the content
        $response = $next($request);
        if (!str_starts_with($request->uri()->path() . '/', 'cp/') && $content = $response->getContent()) {
            $app_url = config('app.url');
            $session_lifetime = config('session.lifetime');
            $csrf_token = $request->session()->token();
		  
		  	// Insert the custom heartbeat script before the  tag
		  	// This script schedules a heartbeat request to happen before the session expires
		  	// Then it intercepts all fetch requests and checks to see if it is going to
		  	// the app url, if it is then the heartbeat can be delayed for a bit longer
            $response->setContent(str_replace('', <<<HTML
                    const heartbeatInterval = 1000 * 60 * {$session_lifetime} * 0.80;
                    let heartbeatTimeout;
                    const heartbeat = () => fetch('/__heartbeat', { method: 'POST', headers: { 'X-CSRF-TOKEN': '{$csrf_token}' } });
                    const queueHeartbeat = () => {
                        console.log('Queueing heartbeat', new Date(Date.now() + heartbeatInterval).toLocaleTimeString());
                        clearTimeout(heartbeatTimeout);
                        heartbeatTimeout = setTimeout(heartbeat, heartbeatInterval);
                    };
                    queueHeartbeat();

                    window.oldFetch = window.fetch;
                    window.fetch = async (...args) => oldFetch.apply(this, args).then((response) => {
                        if (response.url.indexOf('{$app_url}') === 0) {
                            queueHeartbeat();
                        }

                        return response;
                    })
                
            
            HTML, $content));
        }

        return $response;
    }
}