<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class EnsurePasswordIsReset
{
    /**
     * Redirect authenticated users who must reset their password.
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check() && Auth::user()->force_password_reset) {
            if ($this->requestAllowed($request)) {
                return $next($request);
            }

            return redirect()->route('settings.password');
        }

        return $next($request);
    }

    /**
     * Determine if the incoming request should bypass the force-reset redirect.
     */
    protected function requestAllowed(Request $request): bool
    {
        if ($request->routeIs('settings.password', 'logout')) {
            return true;
        }

        if ($request->is('livewire/*')) {
            $referer = $request->headers->get('referer', '');

            return str_contains($referer, route('settings.password'));
        }

        return false;
    }
}
