<?php

namespace App\Http\Controllers;

use App\Services\Installation\SystemHealthService;
use Illuminate\Contracts\View\View;

class SystemHealthController extends Controller
{
    public function __construct(protected SystemHealthService $health)
    {
    }

    /**
     * Show the system health dashboard.
     */
    public function index(): View
    {
        // Only superadmins can access this
        if (! auth()->user()?->hasRole('superadmin')) {
            abort(403, 'Unauthorized access to system health dashboard.');
        }

        $healthSummary = $this->health->getHealthSummary();

        return view('admin.system-health', [
            'summary' => $healthSummary,
        ]);
    }

    /**
     * Quick verification check (returns JSON).
     */
    public function verify()
    {
        // Only superadmins can access this
        if (! auth()->user()?->hasRole('superadmin')) {
            abort(403);
        }

        $healthSummary = $this->health->getHealthSummary();

        return response()->json($healthSummary);
    }
}
