<?php

namespace App\Http\Controllers;

use App\Mail\Tickets\Response;

use App\Models\{Responses,Tickets,User};
use Illuminate\Http\Request;

use Illuminate\Support\Facades\{Auth, Mail};
use Illuminate\Support\{Str,Carbon};


class ResponsesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public static function store($response)
    {
        if (Auth::check() and Auth::user()->id) {
            $user_id = Auth::user()->id;
        } else {
            $user_id = Tickets::where('id', '=', $response["ticket_number"])
                ->select('user_id')
                ->first()->user_id;
        }
        
        $responses = Responses::create([
            'user_id' => $response["user_id"] ?? $user_id,
            'content' => $response["content"],
            'ticket_number' => $response["ticket_number"],
            'is_note' => $response["is_note"],
            'organize' => $response["organize"] ?? 'ticket',
            'employee_response' => $response["employee_response"],
            'ip_address' => app('request')->ip(),
            'created_at' => Carbon::now(),
            'updated_at' => null,
        ]);
        if ($response["employee_response"] == '1') {
            Tickets::where('id', '=', $response["ticket_number"])
                ->update([
                    'updated_at' => Carbon::now(),
                ]);
            
            $first_check = Tickets::where('id', '=', $response["ticket_number"])->first();
            if($first_check->first_employee_reply == '')
            {
                Tickets::where('id', '=', $response["ticket_number"])
                ->update([
                    'first_employee_reply' => Carbon::now(),
                ]);
            }
        } else {
            Tickets::where('id', '=', $response["ticket_number"])
                ->update([
                    'date_closed' => null,
                    'updated_by_client_at' => Carbon::now(),
                ]);
        }

        // Grabs all the ticket details into an array for the email.
        $grab_response = Responses::where('id', '=', $responses->id)->get()->toArray();
        $grab_ticket = Tickets::where('id', '=', $responses->ticket_number)->get()->toArray();


        if ($responses) {
            if(config("mail.enabled") == 'true' && $response["is_note"] == '0')
            {
                 // Grab the Customers email from the Ticket
                $customer = User::select('email','name')->where('id', '=', $grab_ticket[0]['user_id'])->first();

                // Defines the email address for the user, logged in or the public email address
                $user_email = $customer->email ?? $grab_ticket[0]['public_email'];

                // Defines the name for the user, logged in or the public name
                $customer_name = $customer->name ?? $grab_ticket[0]['public_name'];

                // Send email to customer & Agents
                $employees = User::select('email')->role('admin')->role('employee')->pluck('email')->toArray();

                if(Auth::check() && !Auth::user()->hasAnyRole('superadmin', 'admin', 'employee'))
                {
                    Mail::to($user_email)->bcc($employees)->send(new Response($grab_response[0], $grab_ticket[0], $grab_ticket[0]['public_hash'], $customer_name));
                } else {
                    Mail::to($user_email)->send(new Response($grab_response[0], $grab_ticket[0], $grab_ticket[0]['public_hash'], $customer_name));
                }
            }
            return $responses->id;
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(responses $responses)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(responses $responses)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, responses $responses)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(responses $responses)
    {
        //
    }
}
