<?php

namespace App\Http\Controllers;

use App\Models\Categories;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\Auth;

class CategoriesController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public static function store($category)
    {
        Categories::create([
            'category_name' => $category['category_name'],
            'uri'   =>  $category['uri'],
            'display' => $category['display'],
            'type' => $category['type'],
        ]);
    }

    /**
     * Display the specified resource.
     */
    public function show($uri)
    {
        if (Auth::user() && !auth()->user()->can('view announcement category')) {
            return redirect()->route('view_announcements');
        }

        $category = Categories::where('uri', '=', $uri)->orwhere('id', '=', $uri)->first();
        if($category)
        {
            return view('announcements.categories.view',[
                'category' => $category,
            ]);
        } else {
            return redirect()->route('view_announcements');
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(int $category_id)
    {
        if (!auth()->user()->can('edit announcement category')) {
            return redirect()->route('view_announcements');
        }

        $category = Categories::where('id', '=', $category_id)->first()->getOriginal();

        return view('announcements.categories.edit',[
            'category' => $category,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Categories $categories)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Categories $categories)
    {
        //
    }
}
