<?php

namespace App\Http\Controllers\Api\Two;

use App\Http\Controllers\{Controller, ResponsesController};
use App\Http\Controllers\Api\Two\{ApiController};
use App\Models\{User, Tickets, Responses};
use Illuminate\Http\Request;
use Illuminate\Support\Facades\{Hash, Auth, Http, Mail};
use Illuminate\Support\{Str,Carbon};
use App\Mail\Tickets\Response;

class ApiResponses extends Controller
{
    /**
     * Get all tickets for a user.
     * This method retrieves all tickets associated with the authenticated user.
     */
    public function getResponses(Request $request):mixed
    {
        $connection = ApiController::connection($request->header("Authorization"));
        if ($connection->content() != '{"result":"true"}') {
            return $connection;
        }

        $ticket = Tickets::select('*')->where('id', $request->ticket_id)->first();

        if (!$ticket) {
            return response()->json(['error' => 'Ticket not found'], 404);
        }

        $responses = Responses::where('ticket_number', $ticket->id)
            ->select('responses.*', 'users.name as user_name', 'users.email as user_email')
            ->leftJoin('users', 'responses.user_id', '=', 'users.id')
            ->orderBy('responses.id', config('ticaga.sorting'))->get();

        if ($responses->isEmpty()) {
            return false;
        } else {
            return response()->json(['responses' => $responses], 200);
        }
    }

    public function store(Request $request)
    {
        $connection = ApiController::connection($request->header("Authorization"));
        if ($connection->content() != '{"result":"true"}') {
            return $connection;
        }
        
        $response = Responses::create([
            'user_id' => $request->user_id,
            'content' => $request->content,
            'ticket_number' => $request->ticket_number,
            'is_note' => $request->is_note,
            'organize' => $request->organize ?? 'ticket',
            'employee_response' => $request->employee_response,
            'ip_address' => app('request')->ip() ?? null,
            'created_at' => Carbon::now(),
            'updated_at' => null,
        ]);

        if ($request->employee_response == '1') {
            Tickets::where('id', '=', $request->ticket_number)
                ->update([
                    'updated_at' => Carbon::now(),
                ]);
            
            $first_check = Tickets::where('id', '=', $request->ticket_number)->first();
            if($first_check->first_employee_reply == '')
            {
                Tickets::where('id', '=', $request->ticket_number)
                ->update([
                    'first_employee_reply' => Carbon::now(),
                ]);
            }
        } else {
            Tickets::where('id', '=', $request->ticket_number)
                ->update([
                    'date_closed' => null,
                    'updated_by_client_at' => Carbon::now(),
                ]);
        }

        // Grabs all the ticket details into an array for the email.
        $grab_response = Responses::where('id', '=', $response->id)->get()->toArray();
        $grab_ticket = Tickets::where('id', '=', $responses->ticket_number)->get()->toArray();

        
        if ($response) {
            if(config("mail.enabled") == 'true' && $request->is_note == '0')
            {
                 // Grab the Customers email from the Ticket
                $customer = User::select('email','name')->where('id', '=', $grab_ticket[0]['user_id'])->first();

                // Defines the email address for the user, logged in or the public email address
                $user_email = $customer->email ?? $grab_ticket[0]['public_email'];

                // Defines the name for the user, logged in or the public name
                $customer_name = $customer->name ?? $grab_ticket[0]['public_name'];
                
                // Send email to customer & Agents
                $employees = User::select('email')->role('admin')->role('employee')->pluck('email')->toArray();

                if(Auth::check() && !Auth::user()->hasAnyRole('admin', 'employee'))
                {
                    Mail::to($user_email)->bcc($employees)->send(new Response($grab_response[0], $grab_ticket[0], $grab_ticket[0]['public_hash'], $customer_name));
                } else {
                    Mail::to($user_email)->send(new Response($grab_response[0], $grab_ticket[0], $grab_ticket[0]['public_hash'], $customer_name));
                }
            }
        }

        if (!$response) {
            return response()->json(['error' => "Failed to create the response."], 404);
        } else {
            return response()->json(['id' => $request->ticket_number], 201);
        }
    }
}