<?php

namespace App\Http\Controllers\Api\Two;

use App\Http\Controllers\{Controller, DepartmentsController};
use App\Http\Controllers\Api\Two\{ApiController};
use App\Models\{User, Departments};
use Illuminate\Http\Request;
use Illuminate\Support\Facades\{Hash, Auth, Http};

class ApiDepartments extends Controller
{
    /**
     * Get all the departments.
     * This method retrieves all departments.
     */
    public function getDepartments(Request $request): mixed
    {
        $connection = ApiController::connection($request->header("Authorization"));
        if ($connection->content() != '{"result":"true"}') {
            return $connection;
        }

        if($request->type == 'public') {
            $departments = Departments::select('*')->where('is_public', '=', '1')->where('is_disabled', '=', '0')->where('soft_deleted', '=', '0')->get();
        } elseif($request->type == 'customers') {
            $departments = Departments::select('*')->where('is_public', '!=', '0')->where('is_disabled', '=', '0')->where('soft_deleted', '=', '0')->get();
        } else {
            $departments = Departments::select('*')->where('is_public', '!=', '0')->where('is_disabled', '=', '0')->where('soft_deleted', '=', '0')->get();
        }
        if (!$departments) {
            return response()->json(['error' => 'No departments found.'], 404);
        } else {
            return response()->json(['departments' => $departments], 200);
        }
    }
    
    /**
     * Get all the departments.
     * This method retrieves all departments.
     */
    public function getDepartment(Request $request): mixed
    {
        $connection = ApiController::connection($request->header("Authorization"));
        if ($connection->content() != '{"result":"true"}') {
            return $connection;
        }

        $department = Departments::select('*')->where('id', '=', $request->id)->get();

        if (!$department) {
            return response()->json(['error' => 'No department found.'], 404);
        } else {
            return response()->json(['department' => $department], 200);
        }
    }

    /**
     * Get all the departments.
     * This method retrieves all departments.
     */
    public function getDepartmentSlug(Request $request): mixed
    {
        $connection = ApiController::connection($request->header("Authorization"));
        if ($connection->content() != '{"result":"true"}') {
            return $connection;
        }
        
        $department = Departments::select('*')->where('slug', '=', $request->slug)->get();

        if (!$department) {
            return response()->json(['error' => 'No department found.'], 404);
        } else {
            return response()->json(['department' => $department], 200);
        }
    }
}