<?php

namespace App\Http\Controllers\Api\Two;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\{Hash, Auth, Http};
use Illuminate\Support\Str;
use App\Enums\{Priorities, Status};

class ApiController extends Controller
{
    /**
     * Connection to Ticaga.
     * This method handles the login of an agent to verify the API connection.
     */
    public static function connection($request)
    {

        $secret = Str::substr($request, 6);
        $decoded = Str::fromBase64($secret);
        $decoded_split = explode(':', $decoded);

        // Check if the user exists with the provided email
        $user = User::where('email', $decoded_split[0])->first();
        if(!$user) {
            return response()->json(['message' => 'User not found'], 404);
        } else {
            if(!$user->hasRole('superadmin')) {
                return response()->json(['message' => 'User is not an Administrator'], 403);
            }
            // Check if the api_token matches the user account.
            if($user->api_token === $decoded_split[1]){
                return response()->json(['result' => 'true'], 200);
            } else {
                return response()->json(['message' => 'Invalid API token'], 401);
            }
        }       
    }
    /**
     * Login a user to Ticaga.
     * This method handles the login of a user.
     */
    public function login(Request $request)
    {
        $connection = Self::connection($request->header("Authorization"));
        if ($connection->content() != '{"result":"true"}') {
            return response()->json(['error' => 'Invalid API token'], 409);
        }

        $credentials = [
            'email'    => $request->email,
            'password' => $request->password
        ];
  
        if (Auth::attempt($credentials)) 
        {
            return response()->json([
                'user' => Auth::user(),
            ], 200);
        } else {
            return response()->json([
                'error' => 'Invalid credentials',
            ], 401);
        }
    }

    /**
     * Logout a user from Ticaga.
     * This method handles the logout of a user.
     */
    public function logout(Request $request)
    {
        $user = Auth::user();
        if ($user) {
            Auth::logout();
            // Invalidate the session
            $request->session()->invalidate();
            // Regenerate the CSRF token
            $request->session()->regenerateToken();
            return response()->json(['message' => 'User logged out successfully'], 200);
        } else {
            return response()->json(['error' => 'User not authenticated'], 401);
        }
    }

    public function priorities(Request $request)
    {
        $connection = Self::connection($request->header("Authorization"));
        if ($connection->content() != '{"result":"true"}') {
            return $connection;
        }

        $priorities = collect(Priorities::cases())->map(fn ($case) => [
            'case' => $case->name,
            'value' => $case->value,
            'label' => $case->label(),
            'bgcolour' => $case->colour(),
            'textcolour' => $case->textcolour(),
            'priority' => $case->priority(),
        ])->toArray();

        return response()->json(['priorities' => $priorities], 200);
    }

    public function statuses(Request $request)
    {
        $connection = Self::connection($request->header("Authorization"));
        if ($connection->content() != '{"result":"true"}') {
            return $connection;
        }

        $status = collect(Status::cases())->map(fn ($case) => [
            'case' => $case->name,
            'value' => $case->value,
            'label' => $case->label(),
            'bgcolour' => $case->colour(),
            'textcolour' => $case->textcolour(),
        ])->toArray();

        return response()->json(['status' => $status], 200);
    }
}