<div>
@include('extension.importer::partials.navigation')

<div class="container mx-auto px-8 py-8">
    <div class="space-y-6 pb-16" wire:poll.4s="updateStats">
        <!-- Breadcrumb -->
        <nav class="flex text-sm text-gray-500 dark:text-gray-400" aria-label="Breadcrumb">
            <ol class="inline-flex items-center space-x-1 md:space-x-3">
                <li class="inline-flex items-center">
                    <a href="{{ route('extensions.importer.index') }}"
                       class="inline-flex items-center gap-1 text-gray-600 hover:text-indigo-500 dark:text-gray-300 dark:hover:text-indigo-400 transition">
                        <x-heroicon-o-arrow-uturn-left class="w-4 h-4" />
                        Importer
                    </a>
                </li>
                <li>
                    <div class="flex items-center">
                        <x-heroicon-s-chevron-right class="w-4 h-4 text-gray-400" />
                        <span class="ml-1 text-gray-500 dark:text-gray-400">{{ $sourceLabel }} Import</span>
                    </div>
                </li>
            </ol>
        </nav>

        <!-- Status alerts -->
        @if (session('error'))
            <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 rounded-xl px-4 py-3">
                {{ session('error') }}
            </div>
        @endif

        @if (session('success'))
            <div class="bg-emerald-50 dark:bg-emerald-900/20 border border-emerald-200 dark:border-emerald-800 text-emerald-700 dark:text-emerald-200 rounded-xl px-4 py-3">
                {{ session('success') }}
            </div>
        @endif

        @if (session('warning'))
            <div class="bg-amber-50 dark:bg-amber-900/20 border border-amber-200 dark:border-amber-800 text-amber-700 dark:text-amber-200 rounded-xl px-4 py-3">
                {{ session('warning') }}
            </div>
        @endif

        @if (session('message'))
            <div class="bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 text-blue-700 dark:text-blue-200 rounded-xl px-4 py-3">
                {{ session('message') }}
            </div>
        @endif

        <!-- Progress -->
        <div class="rounded-xl border border-gray-200 bg-white p-6 shadow-sm dark:border-gray-700 dark:bg-gray-900">
            <div class="flex items-center justify-between mb-2">
                <span class="text-sm font-medium text-indigo-600">{{ $sourceLabel }} Migration Progress</span>
                <span class="text-sm font-medium text-gray-500 dark:text-gray-300">
                    {{ Str::headline($status) }}
                </span>
            </div>
            <div class="w-full bg-gray-200 rounded-full h-2 dark:bg-gray-800">
                <div class="bg-indigo-600 h-2 rounded-full transition-all duration-300" style="width: {{ $progress }}%"></div>
            </div>
            <div class="mt-2 flex items-center justify-between text-sm text-gray-600 dark:text-gray-300">
                <span>{{ number_format($progress, 1) }}% complete</span>
                @if($eta)
                    <span>ETA: {{ $eta }}</span>
                @endif
            </div>
        </div>

        <!-- Controls -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="rounded-xl border border-gray-200 bg-white p-6 shadow-sm dark:border-gray-700 dark:bg-gray-900 space-y-4">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Actions</h3>
                <div class="flex flex-wrap items-center gap-3">
                    <button wire:click="runDryRun"
                            wire:loading.attr="disabled"
                            wire:target="runDryRun"
                            @disabled($status === 'processing')
                            class="inline-flex items-center gap-2 rounded-xl border border-indigo-600 bg-indigo-600 px-4 py-2 text-sm font-semibold text-white shadow-sm transition hover:bg-indigo-700 disabled:opacity-60 dark:border-indigo-500 dark:bg-indigo-500 dark:hover:bg-indigo-600">
                        <x-heroicon-s-magnifying-glass class="h-5 w-5" />
                        {{ $dryRunResults ? 'Re-run Dry Run' : 'Run Dry Run' }}
                    </button>

                    @if(in_array($status, ['pending', 'processing', 'paused']))
                        <button wire:click="startImport"
                                @disabled($status === 'processing' && $autoRefresh)
                                class="inline-flex items-center px-4 py-2 rounded-lg bg-indigo-600 text-white hover:bg-indigo-700 disabled:opacity-60">
                            <x-heroicon-s-play class="w-5 h-5 mr-2" />
                            {{ $status === 'processing' ? 'Process Next Chunk' : 'Start Import' }}
                        </button>
                    @endif

                    @if($status === 'processing')
                        <button wire:click="pauseImport"
                                class="inline-flex items-center px-4 py-2 rounded-lg bg-amber-600 text-white hover:bg-amber-700">
                            <x-heroicon-s-pause class="w-5 h-5 mr-2" />
                            Pause
                        </button>
                    @elseif($status === 'paused')
                        <button wire:click="resumeImport"
                                class="inline-flex items-center px-4 py-2 rounded-lg bg-emerald-600 text-white hover:bg-emerald-700">
                            <x-heroicon-s-play class="w-5 h-5 mr-2" />
                            Resume
                        </button>
                    @endif
                </div>

                <label class="flex items-center space-x-2 text-sm text-gray-600 dark:text-gray-300">
                    <input type="checkbox" wire:model="autoRefresh"
                           class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500">
                    <span>Automatically process next chunk while import is running</span>
                </label>

                @if($currentStage)
                    <div class="rounded-lg border border-indigo-200 bg-indigo-50 px-4 py-3 text-sm text-indigo-800 dark:border-indigo-800/60 dark:bg-indigo-900/20 dark:text-indigo-200">
                        <div class="font-semibold">Current Stage</div>
                        <div class="mt-1">
                            {{ Str::headline($currentStage) }}
                            @php
                                $stageTotal = $stageTotals[$currentStage] ?? 0;
                                $stageOffset = Arr::get($job->options, "state.offsets.{$currentStage}", 0);
                            @endphp
                            @if($stageTotal)
                                <span class="block text-xs text-indigo-600 dark:text-indigo-300">
                                    {{ number_format(min($stageOffset, $stageTotal)) }} / {{ number_format($stageTotal) }} records
                                </span>
                            @endif
                        </div>
                    </div>
                @endif
            </div>

            <div class="rounded-xl border border-gray-200 bg-white p-6 shadow-sm dark:border-gray-700 dark:bg-gray-900">
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-4">Summary</h3>
                <dl class="grid grid-cols-2 gap-4 text-sm">
                    <div>
                        <dt class="text-gray-500 dark:text-gray-400">Total Records</dt>
                        <dd class="text-lg font-semibold text-gray-900 dark:text-white">{{ number_format($stats['total']) }}</dd>
                    </div>
                    <div>
                        <dt class="text-gray-500 dark:text-gray-400">Imported</dt>
                        <dd class="text-lg font-semibold text-emerald-600 dark:text-emerald-300">{{ number_format($stats['processed']) }}</dd>
                    </div>
                    <div>
                        <dt class="text-gray-500 dark:text-gray-400">Failed</dt>
                        <dd class="text-lg font-semibold text-red-600 dark:text-red-300">{{ number_format($stats['failed']) }}</dd>
                    </div>
                    <div>
                        <dt class="text-gray-500 dark:text-gray-400">Auto Chunking</dt>
                        <dd class="text-lg font-semibold text-gray-900 dark:text-white">{{ number_format($job->chunk_size) }} / batch</dd>
                    </div>
                </dl>
            </div>
        </div>

        <!-- Dry run results -->
        @if($dryRunResults)
            <div class="rounded-xl border border-slate-200 bg-white p-6 shadow-sm dark:border-slate-700 dark:bg-slate-900">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">Dry Run Results</h3>
                        <p class="text-sm text-gray-500 dark:text-gray-400">Simulation processed {{ number_format($dryRunResults['processed'] ?? 0) }} records.</p>
                    </div>
                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                        {{ ($dryRunResults['issues'] ?? 0) > 0
                            ? 'bg-amber-100 text-amber-800 dark:bg-amber-900/20 dark:text-amber-300'
                            : 'bg-emerald-100 text-emerald-800 dark:bg-emerald-900/20 dark:text-emerald-300' }}">
                        {{ ($dryRunResults['issues'] ?? 0) > 0 ? 'Issues found' : 'No issues' }}
                    </span>
                </div>

                @if(!empty($dryRunResults['errors']))
                    <div class="mt-4 space-y-2">
                        @foreach($dryRunResults['errors'] as $error)
                            <div class="rounded-lg border border-amber-200 bg-amber-50 px-4 py-3 text-sm text-amber-800 dark:border-amber-800/60 dark:bg-amber-900/20 dark:text-amber-200">
                                <span class="font-medium">{{ Str::headline($error['type'] ?? 'item') }}</span>
                                @if(!empty($error['source_id']))
                                    <span>#{{ $error['source_id'] }}</span>
                                @endif
                                <div class="mt-1">{{ $error['error'] ?? 'Unknown issue' }}</div>
                            </div>
                        @endforeach
                    </div>
                @endif
            </div>
        @endif

        <!-- Error log -->
        @if(!empty($errors))
            <div class="rounded-xl border border-red-200 bg-white p-6 shadow-sm dark:border-red-800/60 dark:bg-red-900/20">
                <h3 class="text-lg font-semibold text-red-700 dark:text-red-200 flex items-center">
                    <x-heroicon-s-exclamation-triangle class="w-5 h-5 mr-2" />
                    Import Errors
                </h3>
                <p class="text-sm text-red-600 dark:text-red-300 mt-1">
                    Review the failures below. You can resume the import after addressing them.
                </p>

                <div class="mt-4 space-y-3 max-h-80 overflow-y-auto">
                    @foreach($errors as $error)
                        <div class="rounded-lg border border-red-200 bg-red-50 px-4 py-3 text-sm text-red-700 dark:border-red-800/70 dark:bg-red-900/30 dark:text-red-200">
                            <div class="font-semibold">
                                {{ Str::headline($error['type'] ?? 'item') }}
                                @if(!empty($error['source_id'])) #{{ $error['source_id'] }} @endif
                            </div>
                            <p class="mt-1">{{ $error['error'] ?? 'Unknown error' }}</p>
                        </div>
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</div>
</div>
