<div>
@include('extension.importer::partials.navigation')

<div class="container mx-auto px-8 py-8">
    <div class="space-y-6">
        @if($error)
            <div class="bg-red-50 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-200 px-4 py-3 rounded">
                {{ $error }}
            </div>
        @endif

        <div class="bg-white dark:bg-gray-800 shadow rounded-lg p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-500 dark:text-gray-400">Job #{{ $job->id }}</p>
                    <h2 class="text-xl font-semibold text-gray-900 dark:text-white">{{ $job->name }}</h2>
                </div>
                <div class="text-right text-sm">
                    <div>Status: <span class="font-medium">{{ $job->status }}</span></div>
                    <div>Progress: {{ $job->processed_rows }} / {{ $job->total_rows }} ({{ number_format($job->total_rows ? $job->processed_rows / max(1,$job->total_rows) * 100 : 0, 2) }}%)</div>
                    <div>ETA: {{ $job->etaForHumans() ?? '—' }}</div>
                </div>
            </div>

            <div class="mt-4 flex gap-3">
                <button wire:click="runChunk" class="px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white rounded">Run 1 Chunk</button>
                <button wire:click="runAll" class="px-4 py-2 bg-green-600 hover:bg-green-700 text-white rounded">Run All</button>
            </div>

            @if($result)
                <pre class="mt-4 text-xs bg-gray-900 text-gray-100 p-3 rounded overflow-x-auto">{{ json_encode($result, JSON_PRETTY_PRINT) }}</pre>
            @endif
        </div>
    </div>
</div>
</div>
