<?php

use App\Extensions\Concerns\ChecksExtensionInstallation;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    use ChecksExtensionInstallation;

    /**
     * Ensure the importer_jobs table exists for environments where the
     * original installation migration may not have executed.
     */
    public function up(): void
    {
        if (Schema::hasTable('importer_jobs')) {
            return;
        }

        Schema::create('importer_jobs', function (Blueprint $table) {
            $table->id();

            // Job identification
            $table->string('name')->nullable();
            $table->enum('source', ['csv', 'database', 'supportpal'])->default('csv');
            $table->enum('type', ['customers', 'tickets', 'responses', 'announcements', 'departments', 'supportpal'])->default('customers');
            $table->enum('status', ['pending', 'processing', 'completed', 'failed', 'paused'])->default('pending');

            // Progress tracking
            $table->integer('total_rows')->default(0);
            $table->integer('processed_rows')->default(0);
            $table->integer('failed_rows')->default(0);
            $table->integer('current_offset')->default(0);
            $table->integer('chunk_size')->default(100);

            // Source details
            $table->string('file_path')->nullable();
            $table->json('db_config')->nullable();

            // Field mapping
            $table->json('field_mapping')->nullable();

            // Options
            $table->json('options')->nullable();

            // Results
            $table->json('errors')->nullable();
            $table->text('result_summary')->nullable();

            // Timestamps
            $table->timestamp('started_at')->nullable();
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();

            // Indexes
            $table->index('status');
            $table->index(['source', 'type']);
            $table->index('created_at');
        });
    }

    /**
     * No down migration to avoid dropping data inadvertently.
     */
    public function down(): void
    {
        // Skip rollback if extension is not installed
        if ($this->shouldSkipRollback('importer')) {
            return;
        }

        // Intentionally left blank.
    }
};
