<?php

use App\Extensions\Concerns\ChecksExtensionInstallation;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\{DB, Schema};

return new class extends Migration
{
    use ChecksExtensionInstallation;

    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('importer_jobs')) {
            return;
        }

        DB::statement("
            ALTER TABLE `importer_jobs`
            MODIFY `type` ENUM('customers', 'tickets', 'responses', 'announcements', 'departments', 'supportpal')
            NOT NULL
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Skip rollback if extension is not installed
        if ($this->shouldSkipRollback('importer')) {
            return;
        }

        if (!Schema::hasTable('importer_jobs')) {
            return;
        }

        DB::table('importer_jobs')
            ->where('type', 'supportpal')
            ->update(['type' => 'tickets']);

        DB::statement("
            ALTER TABLE `importer_jobs`
            MODIFY `type` ENUM('customers', 'tickets', 'responses', 'announcements', 'departments')
            NOT NULL
        ");
    }
};
