<?php

namespace App\Extensions\Installed\Importer\Services\ApiAdapters;

interface ApiImportAdapter
{
    public static function id(): string;
    public static function label(): string;
    public static function defaults(): array;
    public static function isPreview(): bool;
    public function boot(array $apiConfig, array $options = []): void;
    public function stages(): array;
    public function count(string $stage): int;
    public function fetch(string $stage, int $offset, int $limit): array;
    public function mapStatus(?int $statusId): string;
    public function mapPriority(?int $priorityId): string;
    public function isOperatorUser(int $userId): bool;
    public function findUser(int $userId): ?array;
}
