<?php

use App\Extensions\Concerns\ChecksExtensionInstallation;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    use ChecksExtensionInstallation;

    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!$this->extensionIsInstalled('demo') || !Schema::hasTable('demo_logs')) {
            return;
        }

        Schema::table('demo_logs', function (Blueprint $table) {
            //
        });

        $this->dropForeignKeyIfExists('demo_logs', 'demo_logs_user_id_foreign');
        $this->dropForeignKeyIfExists('demo_logs', 'demo_logs_ticket_id_foreign');
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Skip rollback if extension is not installed
        if ($this->shouldSkipRollback('demo')) {
            return;
        }

        // Intentionally left blank — foreign keys are no longer required.
    }

    protected function dropForeignKeyIfExists(string $table, string $constraint): void
    {
        $connection = Schema::getConnection();
        $database = $connection->getDatabaseName();

        $exists = DB::table('information_schema.TABLE_CONSTRAINTS')
            ->where('TABLE_SCHEMA', $database)
            ->where('TABLE_NAME', $table)
            ->where('CONSTRAINT_NAME', $constraint)
            ->exists();

        if ($exists) {
            DB::statement(sprintf('ALTER TABLE %s DROP FOREIGN KEY %s', $table, $constraint));
        }
    }
};
