<?php

    namespace App\Enums;

    enum Type: string
    {
        case Announcements = 'announcements';
        case KnowledgeBase = 'knowledgebase';

        public static function values(): array
        {
            return array_column(self::cases(), 'name', 'value');
        }

        public function label(): string
        {
            return match ($this) {
                static::Announcements => 'Announcements',
                static::KnowledgeBase => 'Knowledgebase',
            };
        }
    }