<?php

    namespace App\Enums;

    enum Status: string
    {
        case Closed = 'closed';
        case Open = 'open';
        case AwaitingReply = 'awaiting reply';
        case InProgress = 'in progress';

        public static function values(): array
        {
            return array_column(self::cases(), 'name', 'value');
        }


        public function label(): string
        {
            return match ($this) {
                static::Closed => 'Closed',
                static::Open => 'Open',
                static::AwaitingReply => 'Awaiting Reply',
                static::InProgress => 'In Progress',
            };
        }

        public function colour(): string
        {
            return match ($this) {
                static::Closed => 'bg-red-100 dark:bg-red-900',
                static::Open => 'bg-green-100 dark:bg-green-900',
                static::AwaitingReply => 'bg-yellow-100 dark:bg-yellow-900',
                static::InProgress => 'bg-purple-100 dark:bg-purple-900',
            };
        }

        public function textcolour(): string
        {
            return match ($this) {
                static::Closed => 'text-red-800 dark:text-red-100',
                static::Open => 'text-green-800 dark:text-green-300',
                static::AwaitingReply => 'text-yellow-800 dark:text-yellow-300',
                static::InProgress => 'text-purple-800 dark:text-purple-300',
            };
        }
    }