<?php

    namespace App\Enums;

    enum Priorities: string
    {
        case None  = 'none';
        case Low        = 'low';
        case Medium     = 'medium';
        case High       = 'high';
        case Emergency  = 'emergency';

        public static function values(): array
        {
            return array_column(self::cases(), 'name', 'value');
        }

        public function label(): string
        {
            return match ($this) {
                static::None        => 'Not Set',
                static::Low         => 'Low',
                static::Medium      => 'Medium',
                static::High        => 'High',
                static::Emergency   => 'Emergency',
            };
        }

        public function colour(): string
        {
            return match ($this) {
                static::None         => 'bg-slate-100 dark:bg-slate-900',
                static::Low         => 'bg-green-100 dark:bg-green-900',
                static::Medium      => 'bg-yellow-100 dark:bg-yellow-900',
                static::High        => 'bg-pink-100 dark:bg-pink-900',
                static::Emergency   => 'bg-red-100 dark:bg-red-900',
            };
        }

        public function textcolour(): string
        {
            return match ($this) {
                static::None         => 'text-slate-800 dark:text-slate-300',
                static::Low         => 'text-green-800 dark:text-green-300',
                static::Medium      => 'text-yellow-800 dark:text-yellow-300',
                static::High        => 'text-pink-800 dark:text-pink-300',
                static::Emergency   => 'text-red-800 dark:text-red-300',
            };
        }

        public function priority(): bool
        {
            return match ($this) {
                static::None        => false,
                static::Low         => false,
                static::Medium      => false,
                static::High        => true,
                static::Emergency   => true,
            };
        }

        public function description(): string
        {
            return match ($this) {
                static::None        => 'No priority assigned to this ticket',
                static::Low         => 'Minor issues that can be addressed when time permits',
                static::Medium      => 'Standard issues requiring attention in normal workflow',
                static::High        => 'Important issues that need prompt attention',
                static::Emergency   => 'Critical issues requiring immediate action',
            };
        }
    }