<?php

namespace App\Enums;

enum Organize: string
{
    case Ticket = 'ticket';
    case Email = 'email';
    case Blesta = 'blesta';
    case WHMCS = 'whmcs';
    case ClientExec = 'ClientExec';

    case LiveChat = 'livechat';

    public static function values(): array
    {
        return array_column(self::cases(), 'name', 'value');
    }

    public function label(): string
    {
        return match ($this) {
            static::Ticket => 'Ticket',
            static::Email => 'Email',
            static::Blesta => 'Blesta',
            static::WHMCS => 'WHMCS',
            static::ClientExec => 'ClientExec',
            static::LiveChat => 'LiveChat',
        };
    }

    public function billing_system(): bool
    {
        return match ($this) {
            static::Ticket => false,
            static::Email => false,
            static::Blesta => true,
            static::WHMCS => true,
            static::ClientExec => true,
            static::LiveChat => false,
        };
    }

    public static function billingSystemsOnly(): array
    {
        return collect(self::cases())
            ->filter(fn($case) => $case->billing_system())
            ->mapWithKeys(fn($case) => [$case->value => $case->label()])
            ->toArray();
    }

    public function isTicket(): bool
    {
        return $this === self::Ticket;
    }

}
