<?php

namespace App\Enums;

enum LogType: string
{
    case User = 'user';
    case Error = 'error';
    case Notice = 'notice';
    case Email = 'email';
    case Security = 'security';

    public static function values(): array
    {
        return array_column(self::cases(), 'name', 'value');
    }

    public function label(): string
    {
        return match ($this) {
            static::User => 'User',
            static::Error => 'Error',
            static::Notice => 'Notice',
            static::Email => 'Email',
            static::Security => 'Security',
        };
    }

    public function priority(): int
    {
        return match ($this) {
            static::Error, 
            static::Security => 1,
            default => 0,
        };
    }

    public function isPriority(): bool
    {
        return $this->priority() === 1;
    }
}
