<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

class ClearLaravelLog extends Command
{
    protected $signature = 'log:clear';
    protected $description = 'Clear the Laravel log file';

    public function handle()
    {
        $logFile = storage_path('logs/laravel.log');

        if (file_exists($logFile)) {
            file_put_contents($logFile, ''); // truncate
        }

        $this->info('laravel.log cleared!');
        return Command::SUCCESS;
    }
}