/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId])
/******/ 			return installedModules[moduleId].exports;
/******/
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			exports: {},
/******/ 			id: moduleId,
/******/ 			loaded: false
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.loaded = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "/build/";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ function(module, exports, __webpack_require__) {

	"use strict";
	
	var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();
	
	const chai_1 = __webpack_require__(1);
	const parseXMLHeredoc_1 = __webpack_require__(2);
	describe("parseXMLHeredoc", () => {
	    let result;
	    let remainder;
	    describe("tag with content", () => {
	        before(() => {
	            const input = "<abc a='1' b=\"2\" c>content</abc>abcd";
	
	            var _parseXMLHeredoc_1$pa = parseXMLHeredoc_1.parseXMLHeredoc(input);
	
	            var _parseXMLHeredoc_1$pa2 = _slicedToArray(_parseXMLHeredoc_1$pa, 2);
	
	            result = _parseXMLHeredoc_1$pa2[0];
	            remainder = _parseXMLHeredoc_1$pa2[1];
	        });
	        it("parses tag name", () => {
	            chai_1.assert.equal(result.tag, "abc");
	        });
	        it("parses attributes", () => {
	            chai_1.assert.deepEqual(result.attrs, {
	                a: "1",
	                b: "2",
	                c: true
	            });
	        });
	        it("parses content", () => {
	            chai_1.assert.deepEqual(result.content, "content");
	        });
	        it("returns raw html", () => {
	            chai_1.assert.equal(result.raw, "<abc a='1' b=\"2\" c>content</abc>");
	        });
	        it("returns unparsed remainder", () => {
	            chai_1.assert.equal(remainder, "abcd");
	        });
	    });
	    describe("self-closing tag", () => {
	        before(() => {
	            const input = "<abc a='1' b=\"2\" c/>";
	
	            var _parseXMLHeredoc_1$pa3 = parseXMLHeredoc_1.parseXMLHeredoc(input);
	
	            var _parseXMLHeredoc_1$pa4 = _slicedToArray(_parseXMLHeredoc_1$pa3, 2);
	
	            result = _parseXMLHeredoc_1$pa4[0];
	            remainder = _parseXMLHeredoc_1$pa4[1];
	        });
	        it("has no content", () => {
	            chai_1.assert.isUndefined(result.content);
	        });
	        it("returns raw html", () => {
	            chai_1.assert.equal(result.raw, "<abc a='1' b=\"2\" c/>");
	        });
	    });
	    describe("self-closing tag with no attrbiutes", () => {
	        before(() => {
	            const input = "<abc/>abcd";
	
	            var _parseXMLHeredoc_1$pa5 = parseXMLHeredoc_1.parseXMLHeredoc(input);
	
	            var _parseXMLHeredoc_1$pa6 = _slicedToArray(_parseXMLHeredoc_1$pa5, 2);
	
	            result = _parseXMLHeredoc_1$pa6[0];
	            remainder = _parseXMLHeredoc_1$pa6[1];
	        });
	        it("is empty", () => {
	            chai_1.assert.isUndefined(result.content);
	            chai_1.assert.deepEqual(result.attrs, {});
	        });
	        it("returns raw html", () => {
	            chai_1.assert.equal(result.raw, "<abc/>");
	        });
	        it("returns unparsed remainder", () => {
	            chai_1.assert.equal(remainder, "abcd");
	        });
	    });
	});

/***/ },
/* 1 */
/***/ function(module, exports) {

	module.exports = require("chai");

/***/ },
/* 2 */
/***/ function(module, exports) {

	// Adapted from http://erik.eae.net/simplehtmlparser/simplehtmlparser.js
	// Also see: http://ejohn.org/blog/pure-javascript-html-parser/
	"use strict";
	
	exports.startTagRE = /^<([-A-Za-z0-9_]+)((?:\s+\w+(?:\s*=\s*(?:(?:"[^"]*")|(?:'[^']*')|[^>\s]+))?)*)\s*(\/?)>/;
	const endTagRE = /^<\/([-A-Za-z0-9_]+)[^>]*>/;
	const attrRE = /([-A-Za-z0-9_]+)(?:\s*=\s*(?:(?:"((?:\\.|[^"])*)")|(?:'((?:\\.|[^'])*)')|([^>\s]+)))?/g;
	function parseXMLHeredoc(input) {
	    let raw;
	    let remainder = "";
	    const matches = input.match(exports.startTagRE);
	    if (!matches) {
	        return;
	    }
	    raw = matches[0];
	    // console.log(matches);
	    const tagName = matches[1];
	    const tagAttributesString = matches[2] || "";
	    const isSelfClosing = matches[3] === '/';
	    let content;
	    if (!isSelfClosing) {
	        const closeTag = "</" + tagName + ">";
	        const end = input.lastIndexOf(closeTag);
	        content = input.slice(matches[0].length, end);
	        raw += content + closeTag;
	        remainder = input.substring(end + closeTag.length);
	    } else {
	        remainder = input.substring(matches[0].length);
	    }
	    const attrs = parseAttributes(tagAttributesString);
	    const xml = {
	        tag: tagName,
	        attrs: attrs,
	        content: content,
	        raw: raw
	    };
	    return [xml, remainder];
	}
	exports.parseXMLHeredoc = parseXMLHeredoc;
	function parseAttributes(input) {
	    const attrs = {};
	    input.replace(attrRE, function (a0, a1, a2, a3) {
	        const key = a1;
	        let value = a2 || a3 || true;
	        attrs[key] = value;
	        return "";
	    });
	    return attrs;
	}

/***/ }
/******/ ]);
//# sourceMappingURL=parseXMLHeredoc.test.js.map